/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.rlawt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public final class AWTContext {
    private static boolean nativesLoaded = false;
    private long instance;

    public static synchronized void loadNatives() {
        if (nativesLoaded) {
            return;
        }
        System.loadLibrary("jawt");
        String string = System.getProperty("runelite.rlawtpath");
        if (string != null) {
            System.load(string);
            nativesLoaded = true;
            return;
        }
        String string2 = System.getProperty("os.name", "no-os").toLowerCase();
        String string3 = System.getProperty("os.arch", "no-arch");
        String string4 = "unknown";
        if (string2.contains("mac") || string2.contains("darwin")) {
            string2 = "macos";
            string4 = "librlawt.dylib";
        } else if (string2.contains("win")) {
            string2 = "windows";
            string4 = "rlawt.dll";
        } else if (string2.contains("nux")) {
            string2 = "linux";
            string4 = "librlawt.so";
        }
        String string5 = string2 + "-" + string3 + "/" + string4;
        try (InputStream inputStream = AWTContext.class.getResourceAsStream(string5);){
            if (inputStream == null) {
                throw new RuntimeException("rlawt does not exist at " + string5);
            }
            Path path = Files.createTempFile("", string4, new FileAttribute[0]);
            path.toFile().deleteOnExit();
            Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
            System.load(path.toAbsolutePath().toString());
            nativesLoaded = true;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static native long create0(Component var0);

    public AWTContext(Component component) {
        this.instance = AWTContext.create0(component);
        if (this.instance == 0L) {
            throw new NullPointerException();
        }
        int n2 = 0;
        int n3 = 0;
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (container instanceof Window) {
                Insets insets = ((Window)container).getInsets();
                n2 -= insets.left;
                n3 -= insets.top;
                break;
            }
            n2 += container.getX();
            n3 += container.getY();
        }
        this.configureInsets(n2, n3);
    }

    public native void destroy();

    private native void configureInsets(int var1, int var2);

    public native void configurePixelFormat(int var1, int var2, int var3);

    public native void configureMultisamples(int var1);

    public native int getFramebuffer(boolean var1);

    public int getBufferMode() {
        return this.getFramebuffer(true) == 0 ? 1028 : 36064;
    }

    public native void createGLContext();

    public native int setSwapInterval(int var1);

    public native void makeCurrent();

    public native void detachCurrent();

    public native void swapBuffers();

    public native long getGLContext();

    public native long getCGLShareGroup();

    public native long getGLXDisplay();

    public native long getWGLHDC();
}

